<?php
require_once '../includes/Auth.php';
$auth = new Auth();

if ($auth->isUserLoggedIn()) {
    header('Location: dashboard.php');
    exit;
}

$mode = $_GET['mode'] ?? 'login';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($mode === 'login') {
        $result = $auth->userLogin($_POST['username'], $_POST['password']);
        if ($result['success']) {
            header('Location: dashboard.php');
            exit;
        } else {
            $error = "Invalid credentials or account inactive";
        }
    } elseif ($mode === 'register') {
        require_once '../includes/Database.php';
        $db = new Database();
        
        // Get available packages
        $packages = $db->query("SELECT id, name, description, price FROM packages WHERE is_active = 1")->fetchAll();
        
        $data = [
            'username' => $_POST['username'],
            'email' => $_POST['email'],
            'password' => $_POST['password'],
            'package_id' => $_POST['package_id']
        ];
        
        $result = $auth->userRegister($data);
        if ($result['success']) {
            $success = "Registration successful! You can now login.";
            $mode = 'login';
        } else {
            $error = $result['message'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Portal - Flussonic Streaming</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; }
        .auth-container { max-width: 800px; margin: 50px auto; }
        .card { border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); }
        .nav-tabs { border: none; }
        .nav-tabs .nav-link { border: none; color: #666; }
        .nav-tabs .nav-link.active { color: #667eea; border-bottom: 2px solid #667eea; }
        .package-card { border: 1px solid #ddd; border-radius: 10px; transition: all 0.3s; }
        .package-card:hover { transform: translateY(-5px); box-shadow: 0 5px 15px rgba(0,0,0,0.1); }
        .package-card.selected { border-color: #667eea; background: rgba(102, 126, 234, 0.05); }
    </style>
</head>
<body>
    <div class="container auth-container">
        <div class="card">
            <div class="card-body p-5">
                <div class="text-center mb-4">
                    <h2 class="fw-bold">Flussonic Streaming</h2>
                    <p class="text-muted">Professional Streaming Solution</p>
                </div>
                
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>
                
                <?php if (isset($success)): ?>
                    <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
                <?php endif; ?>
                
                <ul class="nav nav-tabs justify-content-center mb-4">
                    <li class="nav-item">
                        <a class="nav-link <?php echo $mode === 'login' ? 'active' : ''; ?>" 
                           href="?mode=login">Login</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo $mode === 'register' ? 'active' : ''; ?>" 
                           href="?mode=register">Register</a>
                    </li>
                </ul>
                
                <?php if ($mode === 'login'): ?>
                    <form method="POST">
                        <div class="mb-3">
                            <label for="username" class="form-label">Username</label>
                            <input type="text" class="form-control" id="username" name="username" required>
                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label">Password</label>
                            <input type="password" class="form-control" id="password" name="password" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Login</button>
                        <div class="text-center mt-3">
                            <a href="forgot-password.php" class="text-muted">Forgot Password?</a>
                        </div>
                    </form>
                <?php else: ?>
                    <form method="POST" id="registerForm">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="username" class="form-label">Username</label>
                                <input type="text" class="form-control" id="username" name="username" required>
                            </div>
                            <div class="col-md-6">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>
                            <div class="col-md-6">
                                <label for="confirm_password" class="form-label">Confirm Password</label>
                                <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                            </div>
                        </div>
                        
                        <div class="mb-4">
                            <label class="form-label">Select Package</label>
                            <div class="row" id="packageSelection">
                                <?php foreach ($packages as $package): ?>
                                <div class="col-md-4 mb-3">
                                    <div class="package-card p-3 text-center" 
                                         onclick="selectPackage(this, <?php echo $package['id']; ?>)">
                                        <h5><?php echo htmlspecialchars($package['name']); ?></h5>
                                        <p class="text-muted small"><?php echo htmlspecialchars($package['description']); ?></p>
                                        <h4 class="text-primary">$<?php echo number_format($package['price'], 2); ?></h4>
                                        <input type="radio" name="package_id" value="<?php echo $package['id']; ?>" 
                                               style="display: none;" required>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        
                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" id="terms" required>
                            <label class="form-check-label" for="terms">
                                I agree to the Terms and Conditions
                            </label>
                        </div>
                        
                        <button type="submit" class="btn btn-primary w-100">Register</button>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <script>
        function selectPackage(element, packageId) {
            // Remove selected class from all packages
            document.querySelectorAll('.package-card').forEach(card => {
                card.classList.remove('selected');
                card.querySelector('input[type="radio"]').checked = false;
            });
            
            // Add selected class to clicked package
            element.classList.add('selected');
            element.querySelector('input[type="radio"]').checked = true;
        }
        
        // Form validation
        document.getElementById('registerForm')?.addEventListener('submit', function(e) {
            const password = document.getElementById('password').value;
            const confirmPassword = document.getElementById('confirm_password').value;
            
            if (password !== confirmPassword) {
                e.preventDefault();
                alert('Passwords do not match!');
            }
        });
    </script>
</body>
</html>