<?php
require_once '../includes/Auth.php';
$auth = new Auth();

if (!$auth->isUserLoggedIn()) {
    header('Location: index.php');
    exit;
}

require_once '../includes/Database.php';
$db = new Database();

$userId = $_SESSION['user_id'];
$user = $db->query(
    "SELECT u.*, p.name as package_name, p.max_streams as package_max_streams, 
            p.max_bandwidth as package_max_bandwidth, p.max_resolution, p.allow_transcoding,
            p.max_transcoding_profiles
     FROM users u 
     LEFT JOIN packages p ON u.package_id = p.id 
     WHERE u.id = ?",
    [$userId]
)->fetch();

// Get user's streams
$streams = $db->query(
    "SELECT * FROM user_streams WHERE user_id = ? ORDER BY created_at DESC",
    [$userId]
)->fetchAll();

// Calculate statistics
$totalBandwidth = $db->query(
    "SELECT SUM(current_bandwidth) as total FROM user_streams WHERE user_id = ? AND status = 'active'",
    [$userId]
)->fetch()['total'] ?? 0;

$totalViewers = $db->query(
    "SELECT SUM(current_viewers) as total FROM user_streams WHERE user_id = ? AND status = 'active'",
    [$userId]
)->fetch()['total'] ?? 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="#">Flussonic Streaming</a>
            <div class="navbar-nav ms-auto">
                <span class="nav-link">Welcome, <?php echo htmlspecialchars($_SESSION['user_username']); ?></span>
                <a class="nav-link" href="dashboard.php">Dashboard</a>
                <a class="nav-link" href="streams.php">Streams</a>
                <a class="nav-link" href="statistics.php">Statistics</a>
                <a class="nav-link" href="?logout=true">Logout</a>
            </div>
        </div>
    </nav>
    
    <div class="container mt-4">
        <div class="row">
            <div class="col-md-4">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5>Account Information</h5>
                    </div>
                    <div class="card-body">
                        <p><strong>Package:</strong> <?php echo htmlspecialchars($user['package_name']); ?></p>
                        <p><strong>Max Streams:</strong> <?php echo $user['max_streams']; ?></p>
                        <p><strong>Max Bandwidth:</strong> <?php echo round($user['max_bandwidth'] / 1000000, 1); ?> Mbps</p>
                        <p><strong>Max Resolution:</strong> <?php echo htmlspecialchars($user['max_resolution']); ?></p>
                        <p><strong>Transcoding:</strong> <?php echo $user['allow_transcoding'] ? 'Enabled' : 'Disabled'; ?></p>
                        <?php if ($user['allow_transcoding']): ?>
                            <p><strong>Max Transcoding Profiles:</strong> <?php echo $user['max_transcoding_profiles']; ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <div class="col-md-8">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="card bg-primary text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-subtitle">Total Bandwidth</h6>
                                        <h3 class="card-title"><?php echo round($totalBandwidth / 1000000, 2); ?> Mbps</h3>
                                    </div>
                                    <i class="bi bi-speedometer2 fs-1 opacity-50"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-success text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-subtitle">Total Viewers</h6>
                                        <h3 class="card-title"><?php echo $totalViewers; ?></h3>
                                    </div>
                                    <i class="bi bi-eye fs-1 opacity-50"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5>Your Streams</h5>
                        <a href="streams.php?action=add" class="btn btn-primary btn-sm">
                            <i class="bi bi-plus-circle me-1"></i> Add Stream
                        </a>
                    </div>
                    <div class="card-body">
                        <?php if (empty($streams)): ?>
                            <p class="text-muted text-center">No streams created yet.</p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Stream Name</th>
                                            <th>Status</th>
                                            <th>Viewers</th>
                                            <th>Bandwidth</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($streams as $stream): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($stream['stream_name']); ?></td>
                                            <td>
                                                <span class="badge bg-<?php echo $stream['status'] === 'active' ? 'success' : ($stream['status'] === 'error' ? 'danger' : 'secondary'); ?>">
                                                    <?php echo ucfirst($stream['status']); ?>
                                                </span>
                                            </td>
                                            <td><?php echo $stream['current_viewers']; ?></td>
                                            <td><?php echo round($stream['current_bandwidth'] / 1000000, 2); ?> Mbps</td>
                                            <td>
                                                <a href="streams.php?action=edit&id=<?php echo $stream['id']; ?>" class="btn btn-sm btn-warning">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <a href="streams.php?action=delete&id=<?php echo $stream['id']; ?>" 
                                                   class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                    <i class="bi bi-trash"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>