<?php
require_once '../includes/Auth.php';
require_once '../includes/Database.php';
require_once '../includes/FlussonicAPI.php';

$auth = new Auth();
if (!$auth->isAdminLoggedIn()) {
    header('Location: index.php');
    exit;
}

$db = new Database();
$action = $_GET['action'] ?? 'list';

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($action === 'add') {
        $data = [
            'name' => $_POST['name'],
            'url' => $_POST['url'],
            'api_key' => $_POST['api_key'],
            'max_bandwidth' => $_POST['max_bandwidth'] * 1000000 // Convert Mbps to bps
        ];
        
        // Test connection
        $flussonic = new FlussonicAPI();
        $flussonic->setServer($data['url'], $data['api_key']);
        
        if ($flussonic->ping()) {
            $stmt = $db->query(
                "INSERT INTO flussonic_servers (name, url, api_key, max_bandwidth) VALUES (?, ?, ?, ?)",
                [$data['name'], $data['url'], $data['api_key'], $data['max_bandwidth']]
            );
            $message = "Server added successfully";
        } else {
            $error = "Failed to connect to Flussonic server";
        }
    } elseif ($action === 'edit' && isset($_GET['id'])) {
        $stmt = $db->query(
            "UPDATE flussonic_servers SET name = ?, url = ?, api_key = ?, max_bandwidth = ?, status = ? WHERE id = ?",
            [
                $_POST['name'],
                $_POST['url'],
                $_POST['api_key'],
                $_POST['max_bandwidth'] * 1000000,
                $_POST['status'],
                $_GET['id']
            ]
        );
        $message = "Server updated successfully";
    } elseif ($action === 'delete' && isset($_GET['id'])) {
        // Check if server has users
        $stmt = $db->query("SELECT COUNT(*) as count FROM users WHERE server_id = ?", [$_GET['id']]);
        $result = $stmt->fetch();
        
        if ($result['count'] == 0) {
            $stmt = $db->query("DELETE FROM flussonic_servers WHERE id = ?", [$_GET['id']]);
            $message = "Server deleted successfully";
        } else {
            $error = "Cannot delete server with active users";
        }
    }
}

// Get all servers
$servers = $db->query("SELECT * FROM flussonic_servers ORDER BY id DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Servers</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>
    <?php include 'header.php'; ?>
    
    <div class="container-fluid mt-4">
        <?php if (isset($message)): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo $message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <?php if (isset($error)): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo $error; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5>Flussonic Servers</h5>
                <a href="?action=add" class="btn btn-primary">
                    <i class="bi bi-plus-circle me-2"></i> Add Server
                </a>
            </div>
            
            <?php if ($action === 'add' || $action === 'edit'): ?>
                <div class="card-body">
                    <form method="POST">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Server Name</label>
                                    <input type="text" class="form-control" id="name" name="name" 
                                           value="<?php echo isset($_GET['id']) ? $servers[0]['name'] : ''; ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label for="url" class="form-label">Server URL</label>
                                    <input type="url" class="form-control" id="url" name="url" 
                                           value="<?php echo isset($_GET['id']) ? $servers[0]['url'] : ''; ?>" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="api_key" class="form-label">API Key</label>
                                    <input type="password" class="form-control" id="api_key" name="api_key" 
                                           value="<?php echo isset($_GET['id']) ? $servers[0]['api_key'] : ''; ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label for="max_bandwidth" class="form-label">Max Bandwidth (Mbps)</label>
                                    <input type="number" class="form-control" id="max_bandwidth" name="max_bandwidth" 
                                           value="<?php echo isset($_GET['id']) ? ($servers[0]['max_bandwidth'] / 1000000) : '1000'; ?>" required>
                                </div>
                                <?php if ($action === 'edit'): ?>
                                <div class="mb-3">
                                    <label for="status" class="form-label">Status</label>
                                    <select class="form-select" id="status" name="status">
                                        <option value="active" <?php echo ($servers[0]['status'] === 'active') ? 'selected' : ''; ?>>Active</option>
                                        <option value="inactive" <?php echo ($servers[0]['status'] === 'inactive') ? 'selected' : ''; ?>>Inactive</option>
                                        <option value="maintenance" <?php echo ($servers[0]['status'] === 'maintenance') ? 'selected' : ''; ?>>Maintenance</option>
                                    </select>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <?php echo $action === 'add' ? 'Add Server' : 'Update Server'; ?>
                            </button>
                            <a href="servers.php" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            <?php else: ?>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>URL</th>
                                    <th>Bandwidth</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($servers as $server): 
                                    $used = ($server['used_bandwidth'] / $server['max_bandwidth']) * 100;
                                ?>
                                <tr>
                                    <td><?php echo $server['id']; ?></td>
                                    <td><?php echo htmlspecialchars($server['name']); ?></td>
                                    <td><?php echo htmlspecialchars($server['url']); ?></td>
                                    <td>
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar <?php echo $used > 80 ? 'bg-danger' : ($used > 60 ? 'bg-warning' : 'bg-success'); ?>" 
                                                 style="width: <?php echo min($used, 100); ?>%">
                                                <?php echo round($server['used_bandwidth'] / 1000000, 1); ?>/<?php echo $server['max_bandwidth'] / 1000000; ?> Mbps
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo $server['status'] === 'active' ? 'success' : ($server['status'] === 'maintenance' ? 'warning' : 'secondary'); ?>">
                                            <?php echo ucfirst($server['status']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <a href="?action=edit&id=<?php echo $server['id']; ?>" class="btn btn-sm btn-warning">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <a href="?action=delete&id=<?php echo $server['id']; ?>" 
                                           class="btn btn-sm btn-danger" 
                                           onclick="return confirm('Are you sure?')">
                                            <i class="bi bi-trash"></i>
                                        </a>
                                        <a href="server_status.php?id=<?php echo $server['id']; ?>" class="btn btn-sm btn-info">
                                            <i class="bi bi-info-circle"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>