<?php
require_once '../includes/Auth.php';
$auth = new Auth();

if (!$auth->isAdminLoggedIn()) {
    header('Location: index.php');
    exit;
}

require_once '../includes/Database.php';
$db = new Database();

// Get statistics
$stats = [
    'total_users' => $db->query("SELECT COUNT(*) as count FROM users")->fetch()['count'],
    'active_streams' => $db->query("SELECT COUNT(*) as count FROM user_streams WHERE status = 'active'")->fetch()['count'],
    'total_servers' => $db->query("SELECT COUNT(*) as count FROM flussonic_servers")->fetch()['count'],
    'total_bandwidth' => $db->query("SELECT SUM(current_bandwidth) as total FROM user_streams WHERE status = 'active'")->fetch()['total'] ?? 0
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        .sidebar { min-height: 100vh; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .sidebar .nav-link { color: white; }
        .sidebar .nav-link:hover { background: rgba(255,255,255,0.1); }
        .stat-card { border-radius: 10px; transition: transform 0.3s; }
        .stat-card:hover { transform: translateY(-5px); }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-2 sidebar p-0">
                <div class="p-4">
                    <h4 class="text-white">Flussonic Control</h4>
                    <p class="text-white-50 small">Admin Panel</p>
                </div>
                <nav class="nav flex-column">
                    <a class="nav-link active" href="dashboard.php">
                        <i class="bi bi-speedometer2 me-2"></i> Dashboard
                    </a>
                    <a class="nav-link" href="servers.php">
                        <i class="bi bi-server me-2"></i> Servers
                    </a>
                    <a class="nav-link" href="packages.php">
                        <i class="bi bi-box me-2"></i> Packages
                    </a>
                    <a class="nav-link" href="users.php">
                        <i class="bi bi-people me-2"></i> Users
                    </a>
                    <a class="nav-link" href="streams.php">
                        <i class="bi bi-cast me-2"></i> Streams
                    </a>
                    <a class="nav-link" href="logs.php">
                        <i class="bi bi-list-check me-2"></i> Logs
                    </a>
                    <a class="nav-link" href="?logout=true">
                        <i class="bi bi-box-arrow-right me-2"></i> Logout
                    </a>
                </nav>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-10 p-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Dashboard</h2>
                    <span class="text-muted">Welcome, <?php echo htmlspecialchars($_SESSION['admin_username']); ?></span>
                </div>
                
                <!-- Stats Cards -->
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card stat-card bg-primary text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-subtitle mb-2">Total Users</h6>
                                        <h2 class="card-title"><?php echo $stats['total_users']; ?></h2>
                                    </div>
                                    <i class="bi bi-people fs-1 opacity-50"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card bg-success text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-subtitle mb-2">Active Streams</h6>
                                        <h2 class="card-title"><?php echo $stats['active_streams']; ?></h2>
                                    </div>
                                    <i class="bi bi-cast fs-1 opacity-50"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card bg-warning text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-subtitle mb-2">Total Servers</h6>
                                        <h2 class="card-title"><?php echo $stats['total_servers']; ?></h2>
                                    </div>
                                    <i class="bi bi-server fs-1 opacity-50"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card bg-info text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-subtitle mb-2">Bandwidth</h6>
                                        <h2 class="card-title"><?php echo round($stats['total_bandwidth'] / 1000000, 2); ?> Mbps</h2>
                                    </div>
                                    <i class="bi bi-speedometer2 fs-1 opacity-50"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Recent Activity -->
                <div class="row">
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header">
                                <h5>Recent Activity</h5>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Admin</th>
                                                <th>Action</th>
                                                <th>Details</th>
                                                <th>Time</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $stmt = $db->query(
                                                "SELECT al.*, a.username FROM admin_logs al 
                                                JOIN admins a ON al.admin_id = a.id 
                                                ORDER BY al.created_at DESC LIMIT 10"
                                            );
                                            while ($log = $stmt->fetch()):
                                            ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($log['username']); ?></td>
                                                <td><span class="badge bg-primary"><?php echo htmlspecialchars($log['action']); ?></span></td>
                                                <td><?php echo htmlspecialchars($log['details']); ?></td>
                                                <td><?php echo date('Y-m-d H:i', strtotime($log['created_at'])); ?></td>
                                            </tr>
                                            <?php endwhile; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h5>Quick Actions</h5>
                            </div>
                            <div class="card-body">
                                <div class="d-grid gap-2">
                                    <a href="servers.php?action=add" class="btn btn-primary">
                                        <i class="bi bi-plus-circle me-2"></i> Add New Server
                                    </a>
                                    <a href="packages.php?action=add" class="btn btn-success">
                                        <i class="bi bi-box me-2"></i> Create Package
                                    </a>
                                    <a href="users.php?action=add" class="btn btn-warning">
                                        <i class="bi bi-person-plus me-2"></i> Add User
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Logout handler
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.get('logout') === 'true') {
            window.location.href = 'index.php?logout=1';
        }
    </script>
</body>
</html>